// Función para manejar el responsive de los gráficos
function handleChartsResize() {
    const charts = document.querySelectorAll('canvas');
    charts.forEach(canvas => {
        if (canvas.chart) {
            canvas.chart.resize();
        }
    });
}

// Función para manejar el responsive del sidebar
function handleSidebarResize() {
    const sidebar = document.getElementById('sidebar');
    if (window.innerWidth >= 1024) {
        sidebar.classList.remove('open');
    }
}

// Función principal para manejar todos los cambios responsive
function handleResponsive() {
    handleChartsResize();
    handleSidebarResize();
}

// Agregar event listener para el resize de la ventana
let resizeTimeout;
window.addEventListener('resize', () => {
    // Debounce para evitar llamadas excesivas
    clearTimeout(resizeTimeout);
    resizeTimeout = setTimeout(handleResponsive, 250);
});

// Ejecutar al cargar la página
document.addEventListener('DOMContentLoaded', handleResponsive); 