class TablePagination {
    constructor(tableId, itemsPerPage = 10) {
        this.table = document.getElementById(tableId);
        this.itemsPerPage = itemsPerPage;
        this.currentPage = 1;
        this.rows = [];
        this.totalPages = 1;

        // Elementos de paginación
        this.firstPageBtn = document.getElementById('firstPage');
        this.prevPageBtn = document.getElementById('prevPage');
        this.nextPageBtn = document.getElementById('nextPage');
        this.lastPageBtn = document.getElementById('lastPage');
        this.currentPageSpan = document.getElementById('currentPage');
        this.totalPagesSpan = document.getElementById('totalPages');

        // Inicializar eventos
        this.initializeEvents();
    }

    initializeEvents() {
        this.firstPageBtn.addEventListener('click', () => this.goToPage(1));
        this.prevPageBtn.addEventListener('click', () => this.goToPage(this.currentPage - 1));
        this.nextPageBtn.addEventListener('click', () => this.goToPage(this.currentPage + 1));
        this.lastPageBtn.addEventListener('click', () => this.goToPage(this.totalPages));
    }

    updateRows(rows) {
        this.rows = Array.from(rows);
        this.totalPages = Math.ceil(this.rows.length / this.itemsPerPage);
        this.currentPage = 1;
        this.updatePagination();
        this.displayRows();
    }

    displayRows() {
        const start = (this.currentPage - 1) * this.itemsPerPage;
        const end = start + this.itemsPerPage;
        
        // Ocultar todas las filas
        this.rows.forEach(row => row.style.display = 'none');
        
        // Mostrar solo las filas de la página actual
        this.rows.slice(start, end).forEach(row => row.style.display = '');
    }

    updatePagination() {
        // Actualizar texto de página actual y total
        this.currentPageSpan.textContent = this.currentPage;
        this.totalPagesSpan.textContent = this.totalPages;

        // Habilitar/deshabilitar botones según corresponda
        this.firstPageBtn.disabled = this.currentPage === 1;
        this.prevPageBtn.disabled = this.currentPage === 1;
        this.nextPageBtn.disabled = this.currentPage === this.totalPages;
        this.lastPageBtn.disabled = this.currentPage === this.totalPages;
    }

    goToPage(page) {
        if (page < 1 || page > this.totalPages) return;
        
        this.currentPage = page;
        this.updatePagination();
        this.displayRows();
    }
} 