// Datos de los cobradores
const cobradores = [
    {
        id: 1,
        nombre: 'José Gutiérrez',
        zona: 'Zona Norte',
        avatar: 'JG',
        telefono: '987-654-321',
        email: 'jose.gutierrez@cobranzas.com',
        iniciales: 'JD',
        cobranzas: 45,
        total: 15420,
        efectividad: 92,
        telefono: '+51 987 654 321',
        email: 'juan.diaz@cobranzas.com'
    },
    {
        iniciales: 'MR',
        nombre: 'María Rodríguez',
        zona: 'Zona Sur',
        cobranzas: 38,
        total: 12850,
        efectividad: 88,
        telefono: '+51 956 789 123',
        email: 'maria.rodriguez@cobranzas.com'
    },
    {
        iniciales: 'CP',
        nombre: 'Carlos Pérez',
        zona: 'Zona Este',
        cobranzas: 52,
        total: 18730,
        efectividad: 95,
        telefono: '+51 945 678 912',
        email: 'carlos.perez@cobranzas.com'
    },
    {
        iniciales: 'AT',
        nombre: 'Ana Torres',
        zona: 'Zona Oeste',
        cobranzas: 41,
        total: 14280,
        efectividad: 87,
        telefono: '+51 934 567 891',
        email: 'ana.torres@cobranzas.com'
    },
    {
        iniciales: 'LG',
        nombre: 'Luis García',
        zona: 'Zona Norte',
        cobranzas: 49,
        total: 16940,
        efectividad: 91,
        telefono: '+51 923 456 789',
        email: 'luis.garcia@cobranzas.com'
    },
    {
        iniciales: 'PV',
        nombre: 'Patricia Vega',
        zona: 'Zona Sur',
        cobranzas: 35,
        total: 11850,
        efectividad: 85,
        telefono: '+51 912 345 678',
        email: 'patricia.vega@cobranzas.com'
    },
    {
        iniciales: 'RM',
        nombre: 'Roberto Mendoza',
        zona: 'Zona Este',
        cobranzas: 43,
        total: 15120,
        efectividad: 89,
        telefono: '+51 901 234 567',
        email: 'roberto.mendoza@cobranzas.com'
    },
    {
        iniciales: 'SC',
        nombre: 'Sandra Castro',
        zona: 'Zona Oeste',
        cobranzas: 47,
        total: 16380,
        efectividad: 93,
        telefono: '+51 989 012 345',
        email: 'sandra.castro@cobranzas.com'
    },
    {
        iniciales: 'DH',
        nombre: 'Diego Huamán',
        zona: 'Zona Norte',
        cobranzas: 39,
        total: 13560,
        efectividad: 86,
        telefono: '+51 978 901 234',
        email: 'diego.huaman@cobranzas.com'
    },
    {
        iniciales: 'VR',
        nombre: 'Valeria Ríos',
        zona: 'Zona Sur',
        cobranzas: 44,
        total: 15890,
        efectividad: 90,
        telefono: '+51 967 890 123',
        email: 'valeria.rios@cobranzas.com'
    }
];

// Función para crear una tarjeta de cobrador
function crearTarjetaCobrador(cobrador, index) {
    return `
        <div class="mdc-card content-section">
            <div class="cobrador-header">
                <div class="cobrador-avatar">${cobrador.iniciales}</div>
                <div class="cobrador-info">
                    <h3 class="cobrador-name">${cobrador.nombre}</h3>
                    <p class="mdc-typography--body2">${cobrador.zona}</p>
                </div>
                <button class="mdc-icon-button material-icons" aria-label="Más opciones">more_vert</button>
            </div>
            <div class="cobrador-stats">
                <div class="stat-item">
                    <div class="stat-value">${cobrador.cobranzas}</div>
                    <div class="stat-label">Cobranzas</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value">S/ ${cobrador.total.toLocaleString()}</div>
                    <div class="stat-label">Total</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value">${cobrador.efectividad}%</div>
                    <div class="stat-label">Efectividad</div>
                </div>
            </div>
            <div class="success-rate">
                <div class="success-rate-fill" style="width: ${cobrador.efectividad}%"></div>
            </div>
            <div class="contact-stats">
                <span class="contact-item">
                    <i class="material-icons contact-icon">phone</i>
                    ${cobrador.telefono}
                </span>
                <span class="contact-item">
                    <i class="material-icons contact-icon">email</i>
                    ${cobrador.email}
                </span>
            </div>
            <div class="chart-container">
                <canvas id="chart${index + 1}"></canvas>
            </div>
        </div>
    `;
}

// Inicialización de componentes MDC
document.addEventListener('DOMContentLoaded', function() {
    // Inicializar todos los botones con ripple
    document.querySelectorAll('.mdc-button').forEach(button => {
        mdc.ripple.MDCRipple.attachTo(button);
    });

    // Inicializar drawer
    const drawer = mdc.drawer.MDCDrawer.attachTo(document.querySelector('.mdc-drawer'));
    
    // Manejar el botón de menú
    document.getElementById('menuButton').addEventListener('click', () => {
        drawer.open = !drawer.open;
    });

    // Inicializar botones de icono
    document.querySelectorAll('.mdc-icon-button').forEach(button => {
        mdc.ripple.MDCRipple.attachTo(button);
        button.classList.add('mdc-ripple-upgraded--unbounded');
    });

    // Renderizar tarjetas de cobradores
    const cobradoresGrid = document.querySelector('.cobradores-grid');
    if (cobradoresGrid) {
        cobradoresGrid.innerHTML = cobradores.map((cobrador, index) => 
            crearTarjetaCobrador(cobrador, index)
        ).join('');
    }

    // Inicializar campos de texto
    document.querySelectorAll('.mdc-text-field').forEach(textField => {
        new mdc.textField.MDCTextField(textField);
    });

    // Inicializar selects
    document.querySelectorAll('.mdc-select').forEach(select => {
        new mdc.select.MDCSelect(select);
    });

    // Inicializar diálogo
    const dialog = new mdc.dialog.MDCDialog(document.querySelector('.mdc-dialog'));

    // Manejar apertura del diálogo de nuevo cobrador
    const addButton = document.getElementById('addCobradorButton');
    if (addButton) {
        addButton.addEventListener('click', () => {
            dialog.open();
        });
    }

    // Inicializar gráficos de ejemplo
    initializeCharts();

    // Implementar búsqueda
    const searchCobrador = document.getElementById('searchCobrador');
    if (searchCobrador) {
        searchCobrador.addEventListener('input', (e) => {
            const searchTerm = e.target.value.toLowerCase();
            const cards = document.querySelectorAll('.mdc-card');
            
            cards.forEach((card, index) => {
                const nombre = cobradores[index].nombre.toLowerCase();
                const zona = cobradores[index].zona.toLowerCase();
                
                if (nombre.includes(searchTerm) || zona.includes(searchTerm)) {
                    card.style.display = '';
                } else {
                    card.style.display = 'none';
                }
            });
        });
    }
});

// Función para inicializar los gráficos
function initializeCharts() {
    const charts = document.querySelectorAll('canvas');
    
    charts.forEach((canvas, index) => {
        const ctx = canvas.getContext('2d');
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun'],
                datasets: [{
                    label: 'Cobranzas Mensuales',
                    data: generateRandomData(6),
                    borderColor: '#3f51b5',
                    tension: 0.4,
                    fill: false
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: {
                            display: false
                        }
                    },
                    x: {
                        grid: {
                            display: false
                        }
                    }
                }
            }
        });
    });
}

// Función auxiliar para generar datos aleatorios
function generateRandomData(count) {
    return Array.from({length: count}, () => Math.floor(Math.random() * 100));
}

// Función para manejar el envío del formulario de nuevo cobrador
const newCobradorForm = document.getElementById('newCobradorForm');
if (newCobradorForm) {
    newCobradorForm.addEventListener('submit', (e) => {
        e.preventDefault();
        // Implementar lógica de guardado
    });
} 